require('dotenv').config();

module.exports = {
  // Server configuration
  // cPanel often uses NODE_PORT environment variable
  server: {
    port: process.env.PORT || process.env.NODE_PORT || 3000,
    host: process.env.HOST || '0.0.0.0'
  },
  
  // RTSP Media Server configuration
  mediaServer: {
    rtmp: {
      port: 1935,
      chunk_size: 60000,
      gop_cache: true,
      ping: 30,
      ping_timeout: 60
    },
    http: {
      port: 8000,
      mediaroot: './media',
      allow_origin: '*'
    },
    // Relay config for node-media-server HLS conversion
    // Use 'ffmpeg' if it's in PATH, otherwise use full path
    relay: {
      ffmpeg: 'ffmpeg', // Will use PATH or can be overridden
      tasks: []
    }
  },
  
  // Dahua Camera configuration
  camera: {
    host: process.env.CAMERA_HOST || '192.168.1.108',
    port: process.env.CAMERA_PORT || 554,
    username: process.env.CAMERA_USERNAME || '',
    password: process.env.CAMERA_PASSWORD || '',
    // Default stream settings
    defaultChannel: parseInt(process.env.CAMERA_CHANNEL) || 1,
    defaultSubtype: parseInt(process.env.CAMERA_SUBTYPE) || 0 // 0: main stream, 1: sub stream 1, 2: sub stream 2
  }
};

